<?php
/**
 * Initialize the custom Theme Options.
 *
 * @package OptionTree
 */

add_action( 'init', 'custom_theme_options' );
/**
 * Build the custom settings & update OptionTree.
 *
 * @since 2.0
 */
function custom_theme_options() {

	// OptionTree is not loaded yet, or this is not an admin request.
	if ( ! function_exists( 'ot_settings_id' ) || ! is_admin() ) {
		return false;
	}

	/**
	 * Get a copy of the saved settings array.
	 */
	$saved_settings = get_option( ot_settings_id(), array() );

	/**
	 * Custom settings array that will eventually be
	 * passes to the OptionTree Settings API Class.
	 */
$custom_settings = array(
'sections'=> array(
array('id'=>'inndex','title' => 'صفحه اصلی'),
array('id'=>'general','title' => 'همگانی'),
array('id'=>'user_profile','title' => 'پروفایل کاربری'),
array('id'=>'shop_settings','title' => 'تنظیمات محصول'),
array('id'=>'socials','title' => 'شبکه های اجتماعی'),
array('id'=>'contacts','title' => 'تماس باما'),
array('id'=>'supports','title' => 'پشتیبانی'),
array('id'=>'url_tar','title' => 'مدیتریت لینکها'),
array('id'=>'footer','title' => 'پانوشت'),
),
'settings'=> array(
//inndex
array(
'id'=>'off_slider_on',
'label'=>'اسلایدر تخفیف',
'desc'=>'اسلایدر تخفیف نمایش داده شود؟',
'std'=>'on',
'type'=>'on-off',
'section'=>'inndex'
),
array(
'id'=>'off_sl_num',
'label'=>'تعداد اسلایدها',
'desc'=>'تعداد محصولات قابل نمایش در اسلایدر را تعیین کنید.',
'std'=>'3',
'type'=>'text',
'section'=>'inndex'
),
array(
'id'=>'eoff_txt',
'label'=>'اتمام تخفیف',
'desc'=>'متن قابل نمایش پس از اتمام تخفیف را وارد کنید.',
'std'=>'<i class="icofont-worried"></i> تمام شد!',
'type'=>'text',
'section'=>'inndex'
),
array(
'id'=>'home2_p',
'label'=>'باکسها',
'desc'=>'باکسهای محصولات و مطالب را ایجاد کنید.',
'type'=>'list-item',
'section'=>'inndex',
'choices'=> array(),
'settings'=> array(
array(
'id'=>'home2_post',
'label'=>'مطلب',
'desc'=>'میخواهید باکس مطلب بسازید ؟',
'std'=>'on',
'type'=>'on-off',
),
array(
'id'=>'home2_pcat',
'label'=>'دسته بندی',
'desc'=>'دسته بندی دلخواه برای نمایش در باکس را انتخاب کنید.',
'std'=>'1',
'type'=>'category-select',
'operator'=>'and',
'condition'=>'home2_post:is(on)'
),
array(
'id'=>'home2_pcat1',
'label'=>'دسته بندی محصولات',
'desc'=>'دسته بندی دلخواه برای نمایش در باکس را انتخاب کنید.',
'std'         => '',
'type'        => 'taxonomy-select',
'post_type'   => 'download',
'taxonomy'    => 'download_category',
'operator'    => 'and',
'choices' => array(),
'condition'=>'home2_post:is(off)'
),
array(
'id'=>'home_m',
'label'=>'عنوان بیشتر',
'desc'=>'عنوان لینک مشاهده مطالب یا محصولات بیشتر را وارد کنید.',
'std'=>'محصولات بیشتر',
'type'=>'text'
),
array(
'id'=>'home2_ppage',
'label'=>'تعداد مطالب',
'desc'=>'تعداد مطالب قابل نمایش را وارد کنید.',
'std'=>'4',
'type'=>'text'
),
)),	
array(
'id' => 'home2_p1',
'label'=>'توضیحات',
'desc'=>'باکسهای مطالب و محصولات این بخش در سمت راست ستون کناری قرار میگیرند.',
'type'=>'textblock',
'section'=>'inndex',
),
array(
'id'=>'home_p',
'label'=>'اسلایدرها',
'desc'=>'اسلایدر محصولات و مطالب را ایجاد کنید.',
'type'=>'list-item',
'section'=>'inndex',
'choices'=> array(),
'settings'=> array(
array(
'id'=>'home_post',
'label'=>'مطلب',
'desc'=>'میخواهید باکس مطلب بسازید ؟',
'std'=>'on',
'type'=>'on-off',
),
array(
'id'=>'home_pcat',
'label'=>'دسته بندی',
'desc'=>'دسته بندی دلخواه برای نمایش در باکس را انتخاب کنید.',
'std'=>'1',
'type'=>'category-select',
'operator'=>'and',
'condition'=>'home_post:is(on)'
),
array(
'id'=>'home_pcat1',
'label'=>'دسته بندی محصولات',
'desc'=>'دسته بندی دلخواه برای نمایش در باکس را انتخاب کنید.',
'std'         => '',
'type'        => 'taxonomy-select',
'post_type'   => 'download',
'taxonomy'    => 'download_category',
'operator'    => 'and',
'choices' => array(),
'condition'=>'home_post:is(off)'
),
array(
'id'=>'home1_m',
'label'=>'عنوان بیشتر',
'desc'=>'عنوان لینک مشاهده مطالب یا محصولات بیشتر را وارد کنید.',
'std'=>'محصولات بیشتر',
'type'=>'text'
),
array(
'id'=>'home_ppage',
'label'=>'تعداد مطالب',
'desc'=>'تعداد مطالب قابل نمایش را وارد کنید.',
'std'=>'4',
'type'=>'text'
),
)),	
array(
'id' => 'home_p1',
'label'=>'توضیحات',
'desc'=>'اسلایدر مطالب و محصولات این بخش بالای فوتر نمایش داده میشوند.',
'type'=>'textblock',
'section'=>'inndex',
),
array(
'id'=>'onf_blg',
'label'=>'وبلاگ',
'desc'=>'باکس وبلاگ نمایش داده شود؟',
'std'=>'on',
'type'=>'on-off',
'section'=>'inndex'
),
array(
'id'=>'blog_title',
'label'=>'عنوان وبلاگ',
'desc'=>'عنوان باکس وبلاگ را وارد کنید.',
'std'=>'',
'type'=>'text',
'section'=>'inndex'
),
array(
'id'=>'blog_pe',
'label'=>'توضیحات وبلاگ',
'desc'=>'توضیحات باکس وبلاگ را وارد کنید.',
'std'=>'',
'type'=>'text',
'section'=>'inndex'
),
array(
'id'=>'blg_cat',
'label'=>'دسته بندی',
'desc'=>'دسته بندی دلخواه برای نمایش در باکس وبلاگ را انتخاب کنید.',
'std'=>'',
'type'=>'category-select',
'section'=>'inndex'
),
array(
'id'=>'blog_num',
'label'=>'تعداد مطالب وبلاگ',
'desc'=>'تعداد مطالب قابل نمایش در باکس وبلاگ را وارد کنید. پیشنهاد: 4 عدد',
'std'=>'',
'type'=>'text',
'section'=>'inndex'
),
array(
'id'=>'blog_mre',
'label'=>'مقالات بیشتر',
'desc'=>'عنوان لینک مقالات بیشتر را وارد کنید.',
'std'=>'مقالات بیشتر ...',
'type'=>'text',
'section'=>'inndex'
),
// general
array(
'id'=>'headers_tab',
'label'=>'تنظیمات کلی',
'type'=>'tab',
'section'=>'general'
),
array(
'id'=>'favicon',
'label'=>'فاویکون',
'desc'=>'پیشنهاد می‌شود اندازه‌ی فاویکون 32px × 32px باشد.',
'std'=> get_stylesheet_directory_uri().'/images/favicon.ico',
'type'=>'upload',
'section'=>'general'
),
array(
'id'=>'logos',
'label'=>'لوگو',
'desc'=>'پیشنهاد می‌شود اندازه‌ی لوگو 70px × 70px باشد.',
'std'=> get_stylesheet_directory_uri().'/images/logo.png',
'type'=>'upload',
'section'=>'general'
),
array(
'id'=>'site_titles',
'label'=>'عنوان کنار لوگو',
'desc'=>'عنوان کنار لوگو سایت را وارد کنید. این متن در تگ h1 قرار میگیرد که برای سئو بسیار مهم است.',
'std'=>'فروشگاه فایل های دانلودی',
'type'=>'text',
'section'=>'general'
),
array(
'id'=>'site_p',
'label'=>'توضیحات کنار لوگو',
'desc'=>'توضیحات کنار لوگو سایت را وارد کنید.',
'std'=>'دانلود فایل بلافاصله پس از پرداخت وجه',
'type'=>'text',
'section'=>'general'
),
array(
'id'=>'login_pp',
'label'=>'ورود و ثبت نام',
'desc'=>'آدرس صفحه ورود یا ثبت نام را وارد کنید.',
'std'=>get_site_url().'/wp-login.php',
'type'=>'text',
'section'=>'general'
),
array(
'id'=>'post_on',
'label'=>'نوع مطلب',
'desc'=>'آیا محصولات دانلودی را از بخش "دانلودها" منتشر میکنید؟',
'std'=>'on',
'type'=>'on-off',
'section'=>'general'
),
array(
'id' => 'post_on1',
'label'=>'توضیحات',
'desc'=>'<p>اگر محصولات دانلودی را از بخش <strong>دانلودها</strong> که مربوط به افزونه edd است اضافه میکنید این بخش را بر روی <strong>بله</strong> تنظیم کنید. (پیشنهاد ما)</p> <p>اگر محصولات دانلودی را از بخش نوشته های خود وردپرس منتشر میکنید این بخش را بر روی <strong>خیر</strong> تنظیم کنید.</p> <p>اگر از بخش نوشته های خود وردپرس برای انتشار محصولات دانلودی استفاده میکنید باید فایل <code>myfunctions.php</code> را ویرایش کنید و کدهای خط 2 تا 5 را حذف کنید.</p>',
'type'=>'textblock',
'section'=>'general',
),
array(
'id'=>'st_on',
'label'=>'منوی ثابت',
'desc'=>'منو به صورت ثابت در بالا بعد از اسکرول صفحه نمایش داده شود ؟',
'std'=>'on',
'type'=>'on-off',
'section'=>'general'
),
array(
'id'=>'darkmode_on',
'label'=>'نمایش حالت شب',
'desc'=>'حالت شب در هدر نمایش داده شود ؟',
'std'=>'on',
'type'=>'on-off',
'section'=>'general'
),
array(
'id'=>'dark_modes',
'label'=>'تم تاریک',
'desc'=>'تم تاریک به صورت پیشفرض فعال شود ؟',
'std'=>'off',
'type'=>'on-off',
'section'=>'general',
),
array(
'id'=>'rel_num',
'label'=>'مقالات مرتبط',
'desc'=>'تعداد مقالات مرتبط قابل نمایش در صفحه ادامه مطلب نوشته ها را وارد کنید.',
'std'=>'4',
'type'=>'text',
'section'=>'general'
),
array(
'id'=>'info_tab',
'label'=>'اطلاعیه',
'type'=>'tab',
'section'=>'general'
),
array(
'id'=>'info_on',
'label'=>'نمایش اطلاعیه',
'desc'=>'اطلاعیه در بالای هدر نمایش داده شود ؟',
'std'=>'off',
'type'=>'on-off',
'section'=>'general'
),
array(
'id'=>'info_p',
'label'=>'توضیحات',
'desc'=>'توضیحات اطلاعیه را وارد کنید. پیشنهاد: حداکثر 30 کلمه باشد.',
'std'=>'',
'type'=>'text',
'section'=>'general'
),
array(
'id'=>'info_url',
'label'=>'لینک',
'desc'=>'لینک اطلاعیه را به همراه http:// وارد کنید.',
'std'=>'',
'type'=>'text',
'section'=>'general'
),
array(
'id'=>'info_button',
'label'=>'متن لینک',
'desc'=>'متن لینک را وارد کنید.',
'std'=>'مشاهده',
'type'=>'text',
'section'=>'general'
),
array(
'id'=>'info_hidde',
'label'=>'مخفی ماندن',
'desc'=>'زمان مخفی ماندن اطلاعیه برحسب ساعت را وارد کنید.',
'std'=>'24',
'type'=>'text',
'section'=>'general'
),
array(
'id' => 'info_hidde1',
'label'=>'توضیحات',
'desc'=>'پس از اینکه کاربر با کلیک بر روی علامت ضربدر، پنچره اطلاعیه را بست، تا وقتیکه زمان تعیین شده طی شود دیگر پنجره اطلاعیه برای کاربر نمایش داده نمیشود.',
'type'=>'textblock',
'section'=>'general',
),
array(
'id'=>'singles_tab',
'label'=>'ادامه مطالب',
'type'=>'tab',
'section'=>'general'
),
array(
'id'=>'navar_txt_on',
'label'=>'نمایش نوار مطالعه',
'desc'=>'نوار مطالعه در صفحه توضیحات مطالب نمایش داده شود ؟',
'std'=>'on',
'type'=>'on-off',
'section'=>'general'
),
array(
'id'=>'navar1_txt_on',
'label'=>'نمایش نوار مطالعه',
'desc'=>'نوار مطالعه در صفحه توضیحات محصول نمایش داده شود ؟',
'std'=>'on',
'type'=>'on-off',
'section'=>'general'
),
array(
'id' => 'navar_txt',
'label'=>'توضیحات',
'desc'=>'وقتی کاربر در حال مطالعه مطلب یا محصول است با اسکرول رو به پایین یک نوار از سمت راست صفحه در بالاترین بخش شروع به حرکت میکند و تا پایان متن نوشته شروع به کامل شدن میکند.<br> برای سفارش <a target="_blank" href="http://tarlanweb.ir">طراحی قالب وردپرس اختصاصی</a> و یا ویرایش قالب فعلی با شماره 09123456789 تماس بگیرید.',
'type'=>'textblock',
'section'=>'general',
),
array(
'id'=>'mobile_tab',
'label'=>'هدر موبایل',
'type'=>'tab',
'section'=>'general'
),
array(
'id'=>'mobile_color',
'label'=>'رنگ مرورگر',
'desc'=>'رنگ مرورگر موبایل را انتخاب کنید.',
'std'=>'#49962d',
'type'=>'colorpicker',
'section'=>'general'
),
array(
'id'=>'mobile_tells',
'label'=>'شماره تماس',
'desc'=>'شماره تماس هدر در حالت موبایل را با فرمت 09123456789 وارد کنید. کاربر پس از کلیک بر روی آیکون تماس امکان تماس مستقیم از طریق موبایل را خواهد داشت.',
'std'=>'',
'type'=>'text',
'section'=>'general'
),
array(
'id'=>'mobile_dark_on',
'label'=>'نمایش حالت شب',
'desc'=>'حالت شب در هدر حالت موبایل نمایش داده شود ؟',
'std'=>'on',
'type'=>'on-off',
'section'=>'general'
),
// user_profile
array(
'id' => 'u_profile',
'label'=>'توضیحات',
'desc'=>'برای ساخت پروفایل حرفه ای مطابق سایت نمونه یا بسته نصبی باید تمام افزونه های موجود در پوشه plugins که در فایل فشرده خریداری شده وجود دارد را نصب و فعال کنید.',
'type'=>'textblock',
'section'=>'user_profile',
),
array(
'id'=>'profile_page',
'label'=>'پروفایل',
'desc'=>'برگه پروفایل را انتخاب کنید.',
'std'=>'',
'type'=>'page-select',
'section'=>'user_profile',
'operator'=>'and',
),
array(
'id' => 'profile_page1',
'label'=>'توضیحات',
'desc'=>'یک برگه جدید بسازید و از بخش <strong>ویژگی های برگه</strong> قالب را بر روی <strong>پروفایل</strong> تنظیم کنید.',
'type'=>'textblock',
'section'=>'user_profile',
),
array(
'id'=>'useredit_page',
'label'=>'ویرایش اطلاعات کاربری',
'desc'=>'برگه ویرایش اطلاعات کاربری را انتخاب کنید.',
'std'=>'',
'type'=>'page-select',
'section'=>'user_profile',
'operator'=>'and',
),
array(
'id' => 'useredit_page1',
'label'=>'توضیحات',
'desc'=>'یک برگه جدید بسازید و از بخش <strong>ویژگی های برگه</strong> قالب را بر روی <strong>ویرایش پروفایل کاربری</strong> تنظیم کنید.',
'type'=>'textblock',
'section'=>'user_profile',
),
array(
'id'=>'favorites_page',
'label'=>'علاقه مندی ها',
'desc'=>'برگه علاقه مندی ها را انتخاب کنید.',
'std'=>'',
'type'=>'page-select',
'section'=>'user_profile',
'operator'=>'and',
),
array(
'id' => 'favorites_page1',
'label'=>'توضیحات',
'desc'=>'یک برگه جدید بسازید و از بخش <strong>ویژگی های برگه</strong> قالب را بر روی <strong>علاقه مندی</strong> تنظیم کنید.',
'type'=>'textblock',
'section'=>'user_profile',
),
array(
'id'=>'wallet_page',
'label'=>'کیف پول',
'desc'=>'برگه کیف پول را انتخاب کنید.',
'std'=>'',
'type'=>'page-select',
'section'=>'user_profile',
'operator'=>'and',
),
array(
'id' => 'wallet_page1',
'label'=>'توضیحات',
'desc'=>'یک برگه جدید بسازید و از بخش <strong>ویژگی های برگه</strong> قالب را بر روی <strong>پروفایل</strong> تنظیم کنید. <br> برای نمایش موجودی کیف پول از شورتکد <code>[edd_wallet_value]</code> و بای نمایش فرم افزایش موجودی از شورتکد <code>[edd_deposit]</code> .',
'type'=>'textblock',
'section'=>'user_profile',
),
array(
'id'=>'dlupdates_page',
'label'=>'آپدیت محصولات',
'desc'=>'برگه دانلود آپدیت محصولات را انتخاب کنید.',
'std'=>'',
'type'=>'page-select',
'section'=>'user_profile',
'operator'=>'and',
),
array(
'id' => 'dlupdates_page1',
'label'=>'توضیحات',
'desc'=>'یک برگه جدید بسازید و از بخش <strong>ویژگی های برگه</strong> قالب را بر روی <strong>پروفایل</strong> تنظیم کنید. سپس شورتکد <code>[download_history]</code> را در ویرایشگر دیداری قرار دهید.',
'type'=>'textblock',
'section'=>'user_profile',
),
array(
'id'=>'histori_page',
'label'=>'سوابق خرید',
'desc'=>'برگه سوابق خرید را انتخاب کنید.',
'std'=>'',
'type'=>'page-select',
'section'=>'user_profile',
'operator'=>'and',
),
array(
'id' => 'histori_page1',
'label'=>'توضیحات',
'desc'=>'یک برگه جدید بسازید و از بخش <strong>ویژگی های برگه</strong> قالب را بر روی <strong>پروفایل</strong> تنظیم کنید. سپس شورتکد <code>[purchase_history]</code> را در ویرایشگر دیداری قرار دهید.',
'type'=>'textblock',
'section'=>'user_profile',
),
array(
'id'=>'ticket_page',
'label'=>'ارسال تیکت',
'desc'=>'برگه ارسال تیکت را انتخاب کنید.',
'std'=>'',
'type'=>'page-select',
'section'=>'user_profile',
'operator'=>'and',
),
array(
'id' => 'ticket_page1',
'label'=>'توضیحات',
'desc'=>'یک برگه جدید بسازید و از بخش <strong>ویژگی های برگه</strong> قالب را بر روی <strong>پروفایل</strong> تنظیم کنید. سپس شورتکد <code>[ticket-submit]</code> را در ویرایشگر دیداری قرار دهید.',
'type'=>'textblock',
'section'=>'user_profile',
),
array(
'id'=>'tickets_page',
'label'=>'تیکتهای پشتیبانی',
'desc'=>'برگه تیکتهای پشتیبانی را انتخاب کنید.',
'std'=>'',
'type'=>'page-select',
'section'=>'user_profile',
'operator'=>'and',
),
array(
'id' => 'tickets_page1',
'label'=>'توضیحات',
'desc'=>'یک برگه جدید بسازید و از بخش <strong>ویژگی های برگه</strong> قالب را بر روی <strong>پروفایل</strong> تنظیم کنید. سپس شورتکد <code>[tickets]</code> را در ویرایشگر دیداری قرار دهید.',
'type'=>'textblock',
'section'=>'user_profile',
),
// footer
array(
'id'=>'onf_up',
'label'=>'برو بالا',
'desc'=>'آیکون حرکت به ابتدای سایت نمایش داده شود؟',
'std'=>'on',
'type'=>'on-off',
'section'=>'footer'
),
array(
'id'=>'ft_amar_on',
'label'=>'نمایش آمار',
'desc'=>'آمار فوتر نمایش داده شود ؟',
'std'=>'on',
'type'=>'on-off',
'section'=>'footer'
),
array(
'id'=>'abt_on',
'label'=>'نمایش درباره ما',
'desc'=>'باکس درباره ما فوتر نمایش داده شود ؟',
'std'=>'on',
'type'=>'on-off',
'section'=>'footer'
),
array(
'id'=>'about_title',
'label'=>'عنوان درباره ما',
'desc'=>'عنوان باکس درباره ما را وارد کنید.',
'std'=>'درباره ما',
'type'=>'text',
'section'=>'footer'
),
array(
'id'=>'about_p',
'label'=>'توضیحات درباره ما',
'desc'=>'توضیحات باکس درباره ما را وارد کنید.',
'std'=>'',
'type'=>'textarea',
'section'=>'footer'
),
array(
'id'=>'address_box',
'label'=>'آدرس',
'desc'=>'آدرس محل مدیریت سایت قابل نمایش در فوتر را وارد کنید.',
'std'=>'',
'type'=>'text',
'section'=>'footer'
),
array(
'id'=>'address_tel',
'label'=>'تلفن',
'desc'=>'شماره تلفن قابل نمایش در فوتر را وارد کنید.',
'std'=>'',
'type'=>'text',
'section'=>'footer'
),
array(
'id'=>'address_mail',
'label'=>'ایمیل',
'desc'=>'ایمیل قابل نمایش در فوتر را وارد کنید.',
'std'=>'',
'type'=>'text',
'section'=>'footer'
),
array(
'id'=>'copy_right',
'label'=>'کپی رایت',
'desc'=>'کپی رایت فوتر را وارد کنید.',
'std'=>'کلیه حقوق وب سایت برای <span>لوتوس فایل</span> محفوظ است.',
'type'=>'text',
'section'=>'footer'
),
//socials
array(
'id'=>'instagram_url',
'label'=>'اینستاگرام',
'desc'=>'آدرس صفحه اینستاگرام را به همراه http:// وارد کنید.',
'std'=>'',
'type'=>'text',
'section'=>'socials'
),
array(
'id'=>'telegram_url',
'label'=>'تلگرام',
'desc'=>'آدرس کانال تلگرام را به همراه http:// وارد کنید.',
'std'=>'',
'type'=>'text',
'section'=>'socials'
),
array(
'id'=>'facebook_url',
'label'=>'فیس بوک',
'desc'=>'آدرس صفحه فیس بوک را به همراه http:// وارد کنید.',
'std'=>'',
'type'=>'text',
'section'=>'socials'
),
array(
'id'=>'linkedin_url',
'label'=>'لینکدین',
'desc'=>'آدرس صفحه لینکدین را به همراه http:// وارد کنید.',
'std'=>'',
'type'=>'text',
'section'=>'socials'
),
array(
'id'=>'twitter_url',
'label'=>'توئیتر',
'desc'=>'آدرس صفحه توئیتر را به همراه http:// وارد کنید.',
'std'=>'',
'type'=>'text',
'section'=>'socials'
),
array(
'id'=>'aparat_url',
'label'=>'آپارات',
'desc'=>'آدرس صفحه آپارات را به همراه http:// وارد کنید.',
'std'=>'',
'type'=>'text',
'section'=>'socials'
),
//shop_settings
array(
'id'=>'shop_title',
'label'=>'عنوان باکس خرید',
'desc'=>'عنوان باکس خرید محصول را وارد کنید.',
'std'=>'خرید و دانلود',
'type'=>'text',
'section'=>'shop_settings'
),
array(
'id'=>'course_tt',
'label'=>'عنوان سرفصل ها',
'desc'=>'عنوان باکس سرفصل های دوره آموزشی را وارد کنید.',
'std'=>'سرفصل دوره',
'type'=>'text',
'section'=>'shop_settings'
),
array(
'id'=>'rel_dl',
'label'=>'محصولات مرتبط',
'desc'=>'تعداد محصولات مرتبط قاب نمایش را وارد کنید.',
'std'=>'4',
'type'=>'text',
'section'=>'shop_settings'
),
array(
'id'=>'bu_helps',
'label'=>'راهنمای خرید محصول',
'desc'=>'عنوان باکس راهنمای خرید محصول را وارد کنید.',
'std'=>'راهنمای خرید محصول',
'type'=>'text',
'section'=>'shop_settings'
),
array(
'id'=>'buy_helps',
'label'=>'راهنمای خرید محصول',
'desc'=>'راهنمای خرید محصول را وارد کنید.',
'std'=>'',
'type'=>'textarea',
'section'=>'shop_settings'
),
array(
'id' => 'buy_helps1',
'label'=>'توضیحات',
'desc'=>'این بخش در ستون کناری صفحه توضیحات محصول نمایش داده میشود.<br> از لیست نشانه دار <code>ul</code> استفاده کنید.',
'type'=>'textblock',
'section'=>'shop_settings',
),
array(
'id'=>'buy_roles',
'label'=>'خدمات',
'desc'=>'خدماتی که در قبال هر محصول ارائه میدهید را وارد کنید.',
'std'=>'',
'type'=>'textarea',
'section'=>'shop_settings'
),
array(
'id' => 'buy_roles1',
'label'=>'توضیحات',
'desc'=>'این بخش در زیر قیمت محصول در صفحه توضیحات محصول نمایش داده میشود.<br> هر خدمت را در یک خط وارد کنید طوریکه داخل تگ <code>p</code> قرار بگیرد.',
'type'=>'textblock',
'section'=>'shop_settings',
),
array(
'id'=>'buy_c_on',
'label'=>'تعداد خرید',
'desc'=>'تعداد خرید محصول در ستون جزئیات نمایش داده شود ؟',
'std'=>'on',
'type'=>'on-off',
'section'=>'shop_settings'
),
//supports
array(
'id'=>'sup_onf',
'label'=>'پشتیبانی',
'desc'=>'باکس پشتیبانی نمایش داده شود ؟',
'std'=>'on',
'type'=>'on-off',
'section'=>'supports'
),
array(
'id'=>'sup_tt',
'label'=>'عنوان',
'desc'=>'عنوان باکس پشتیبانی را وارد کنید.',
'std'=>'پشتیبانی محصولات',
'type'=>'text',
'section'=>'supports'
),
array(
'id'=>'sup_icons',
'label'=>'ایکون',
'desc'=>'نام ایکون را بدون پسوند icofont- وارد کنید.',
'std'=>'life-buoy',
'type'=>'text',
'section'=>'supports'
),
array(
'id'=>'sp_icns',
'label'=>'ایکون هدر',
'desc'=>'نام ایکون هدر باکس پشتیبانی را بدون پسوند icofont- وارد کنید.',
'std'=>'headphone-alt',
'type'=>'text',
'section'=>'supports'
),
array(
'id'=>'sup_iconsd',
'label'=>'توضیحات',
'desc'=>'آیکون حلقه نجات life-buoy - آیکون واتس آپ whatsapp - ایکون تلگرام paper-plane - آیکون تلفن phone - ایکون انسان پشتیبان support - آیکون هدفون پشتیبان headphone-alt',
'type'=>'textblock',
'section'=>'supports',
),
array(
'id'=>'sup_tee',
'label'=>'عنوان',
'desc'=>'عنوان باکس هدر را وارد کنید.',
'std'=>'پشتیبانی محصولات',
'type'=>'text',
'section'=>'supports'
),
array(
'id'=>'sup_pe',
'label'=>'توضیحات',
'desc'=>'توضیحات باکس هدر را وارد کنید.',
'std'=>'برای پشتیبانی محصولات ترلان وب از راه های ارتباطی زیر استفاده کنید.',
'type'=>'text',
'section'=>'supports'
),
array(
'id'=>'sup_al',
'label'=>'پیام',
'desc'=>'پیام پشتیبانی را وارد کنید.',
'std'=>'معمولا کمتر از 20 دقیقه پاسخ میدهیم.',
'type'=>'text',
'section'=>'supports'
),
array(
'id'=>'sup_users',
'label'=>'پشتیبانها',
'desc'=>'لیست پشتیبانها را ایجاد کنید',
'type'=>'list-item',
'section'=>'supports',
'choices'=>array(),
'settings'=>array(
array(
'id'=>'sup_img',
'label'=>'تصویر پشتیبان',
'desc'=>'پیشنهاد می‌شود اندازه‌ی تصویر پشتیبان 50px × 50px باشد.',
'std'=> get_stylesheet_directory_uri().'/images/support-img.png',
'type'=>'upload',
),
array(
'id'=>'sup_pp',
'label'=>'زیر عنوان',
'desc'=>'متن زیر عنوان را وارد کنید.',
'std'=>'مدیریت سایت هستم',
'type'=>'text',
),
array(
'id'=>'sup_p2',
'label'=>'پیام',
'desc'=>'متن پیام را وارد کنید.',
'std'=>'چطوری میتونم کمکتون کنم ؟',
'type'=>'text',
),
array(
'id'=>'sup_whts',
'label'=>'شماره واتس آپ',
'desc'=>'اگر پشتیبانی در واتس آپ است شماره واتس آپ را با فرمت 989123456789 وارد کنید. نکته : برای پشتیبانی تلگرام این فیلد را خالی بگذارید. این فیلد نسبت به شناسه تلگرام اولویت دارد.',
'std'=> '',
'type'=>'text'
),
array(
'id'=>'sup_p3',
'label'=>'پیام',
'desc'=>'ین متن در پیامی که در واتس آپ برایتان ارسال میشود نمایش داده میشود.',
'std'=>'سلام از طریق سایت ترلان وب باهاتون تماس میگیرم',
'type'=>'text',
),
array(
'id'=>'sup_tels',
'label'=>'شناسه تلگرام',
'desc'=>'برای پشتیبانی تلگرام شناسه تلگرام را وارد کنید.نکته: برای پشتیبانی واتس آپ این فیلد را خالی بگذارید.',
'std'=> '',
'type'=>'text',
),
array(
'id'=>'sup_nond',
'label'=>'توضیحات',
'desc'=>'در صورت خالی بودن شناسه تلگرام و شماره واتس آپ، فیلد پشتیبان به صورت غیرفعال نمایش داده میشود.',
'type'=>'textblock'
),
)),
//url_tar
array(
'id'=>'post_tar',
'label'=>'مطالب',
'desc'=>'نوشته ها در تب جدید مرورگر باز شوند؟',
'std'=>'on',
'type'=>'on-off',
'section'=>'url_tar'
),
array(
'id'=>'pr_tar',
'label'=>'محصولات',
'desc'=>'محصولات در تب جدید مرورگر باز شوند؟',
'std'=>'on',
'type'=>'on-off',
'section'=>'url_tar'
),
array(
'id'=>'sl_tar',
'label'=>'اسلایدر تخفیف',
'desc'=>'محصولات اسلایدر تخفیف در تب جدید مرورگر باز شوند؟',
'std'=>'on',
'type'=>'on-off',
'section'=>'url_tar'
),
array(
'id'=>'im_tar',
'label'=>'محصولات و مطالب بیشتر',
'desc'=>'محصولات و مطالب بیشتر ایندکس در تب جدید مرورگر باز شوند؟',
'std'=>'on',
'type'=>'on-off',
'section'=>'url_tar'
),
//contacts
array(
'id'=>'cont_ft',
'label'=>'عنوان فرم',
'desc'=>'عنوان فرم تماس باما را وارد کنید.',
'std'=>'فرم تماس باما',
'type'=>'text',
'section'=>'contacts'
),
array(
'id'=>'cont_fp',
'label'=>'توضیحات فرم',
'desc'=>'توضیحات فرم تماس باما را وارد کنید.',
'std'=>'جهت تماس باما میتوانید از فرم زیر استفاده کنید.',
'type'=>'text',
'section'=>'contacts'
),
array(
'id'=>'cont_fsh',
'label'=>'شورتکد فرم',
'desc'=>'شورتکد فرم تماس باما را وارد کنید.',
'std'=>'',
'type'=>'text',
'section'=>'contacts'
),
array(
'id' => 'cont_fsh1',
'label'=>'توضیحات',
'desc'=>'افزونه فرم تماس 7 را نصب کنید سپس فرم دلخواه تان را بسازید و بعد شورتکد ایجاد شده که مشابه <code>[contact-form-7 id="36958" title="فرم تماس 1"]</code> میباشد را در این فیلد قرار دهید.',
'type'=>'textblock',
'section'=>'contacts',
),
array(
'id'=>'cont_tel',
'label'=>'تلفن',
'desc'=>'شماره تلفن را وارد کنید. در هر خط یک شماره وارد کنید.',
'std'=>'',
'type'=>'textarea',
'section'=>'contacts'
),
array(
'id'=>'cont_addre',
'label'=>'آدرس',
'desc'=>'آدرس دفتر یا آدرسی که برای نماد داده اید را وارد کنید.',
'std'=>'',
'type'=>'textarea',
'section'=>'contacts'
),
array(
'id'=>'cont_mail',
'label'=>'ایمیل',
'desc'=>'ایمیل را وارد کنید. در هر خط یک ایمیل وارد کنید.',
'std'=>'',
'type'=>'textarea',
'section'=>'contacts'
),
array(
'id'=>'googles_mapss',
'label'=>'نقشه محل دفتر',
'desc'=>'کد ایفریم مربوط به نقشه گوگل دفتر را  از بخش متن ویرایشگر زیر وارد کنید.',
'std'=>'',
'type'=>'textarea',
'section'=>'contacts'
),

),
);
	// Allow settings to be filtered before saving.
	$custom_settings = apply_filters( ot_settings_id() . '_args', $custom_settings );
	// Settings are not the same update the DB.
	if ( $saved_settings !== $custom_settings ) {
		update_option( ot_settings_id(), $custom_settings );
	}
	// Lets OptionTree know the UI Builder is being overridden.
	global $ot_has_custom_theme_options;
	$ot_has_custom_theme_options = true;
}